/*
  loopFork.c
  Calls fork N times, printing the return values each time.
  Try with and without wait or break.
 */

#include <stdlib.h>      // exit
#include <stdio.h>       // printf
#include <unistd.h>      // fork
#include <sys/wait.h>    // wait

const int N = 3;

int main(int argc, char* argv[]) {
    if (argc > 2) {
        fprintf(stderr, "Use: loopFork [count]\n");
        exit(1);
    }
	
    int n = (argc == 1) ? N : atoi(argv[1]);
    printf("pid: %d\n", getpid());
    for (int i = 0; i < n; ++i) {
        if (fork() == 0) {
            printf("pid: %d; ppid: %d\n", getpid(), getppid());
	    //            break;
        }
	// else wait(NULL);
    }
}
